#install.packages("survival")
#install.packages("survminer")
#install.packages("timeROC")


#library packages
library(survival)
library(survminer)
library(timeROC)

riskFile="risk.txt"      #risk file
cliFile="clinical.txt"        #clinical data file
setwd("E:\\metabolism\\LGG\\11.clinical\\3.ROC")     

#read risk file
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)
risk=risk[,c("futime", "fustat", "metabolismcluster")]

#read clinical data file
cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)

#data merge
samSample=intersect(row.names(risk), row.names(cli))
risk3=risk[samSample,,drop=F]
cli=cli[samSample,,drop=F]
rt=cbind(risk3, cli)

#define color
bioCol=c("#E67762","#3D8E86","#EBDB7F","#0066FF","#B853F8","#FF0000","#6E568C","#7CC767","#223D6C","#D20A13","#FFD121","#088247","#11AA4D")

######Plot the ROC curve for 1, 3, 5 years######
ROC_rt=timeROC(T=risk$futime, delta=risk$fustat,
	           marker=risk$metabolismcluster, cause=1,
	           weighting='aalen',
	           times=c(1,3,5), ROC=TRUE)
pdf(file="ROC.pdf", width=5.5, height=5.5)
plot(ROC_rt,time=1,col=bioCol[1],title=FALSE,lwd=2)
plot(ROC_rt,time=3,col=bioCol[2],add=TRUE,title=FALSE,lwd=2)
plot(ROC_rt,time=5,col=bioCol[3],add=TRUE,title=FALSE,lwd=2)
legend('bottomright',
	   c(paste0('AUC at 1 years: ',sprintf("%.03f",ROC_rt$AUC[1])),
	     paste0('AUC at 3 years: ',sprintf("%.03f",ROC_rt$AUC[2])),
	     paste0('AUC at 5 years: ',sprintf("%.03f",ROC_rt$AUC[3]))),
	   col=bioCol[1:3], lwd=2, bty = 'n')
dev.off()


######Plotting ROC curves of clinical features######
predictTime=1    #Define the predict year
aucText=c()
pdf(file="cliROC.pdf", width=5.5, height=5.5)
#Plot the ROC curve of the anoiS
i=3
ROC_rt=timeROC(T=risk$futime,
               delta=risk$fustat,
               marker=risk$metabolismcluster, cause=1,
               weighting='aalen',
               times=c(predictTime),ROC=TRUE)
plot(ROC_rt, time=predictTime, col=bioCol[i-2], title=FALSE, lwd=2)
aucText=c(paste0("metabolismcluster", ", AUC=", sprintf("%.3f",ROC_rt$AUC[2])))
abline(0,1)
#Loop the clinical data and draw the ROC curve of the clinical data
for(i in 4:ncol(rt)){
	ROC_rt=timeROC(T=rt$futime,
				   delta=rt$fustat,
				   marker=rt[,i], cause=1,
				   weighting='aalen',
				   times=c(predictTime),ROC=TRUE)
	plot(ROC_rt, time=predictTime, col=bioCol[i-2], title=FALSE, lwd=2, add=TRUE)
	aucText=c(aucText, paste0(colnames(rt)[i],", AUC=",sprintf("%.3f",ROC_rt$AUC[2])))
}
#Plot the legend to get the area under the ROC curve
legend("bottomright", aucText,lwd=2,bty="n",col=bioCol[1:(ncol(rt)-1)])
dev.off()

predictTime=3     #Change the predict year
predictTime=5 
